/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReceiveParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWReceiveCorrelationSetPanel
extends JPanel {
    public static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_XPATH_QUERY_STRING = 1;
    private VWReceiveParamPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JPanel m_basicPanel = null;
    private JPanel m_advancedPanel = null;
    private JTextField m_correlationExpression = null;
    private JTextField m_correlationParam = null;
    private JTextField m_receiveName = null;
    private String[][] m_receiveParams = null;
    private String[] m_receiveParamsTableColumnNames = new String[]{VWResource.s_name, VWResource.s_xpathQueryString};
    private VWTable m_receiveParamsTable = null;
    private AbstractTableModel m_receiveParamsTableModel = null;

    public VWReceiveCorrelationSetPanel(VWReceiveParamPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWReceiveInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        this.m_basicPanel = this.createBasicPanel();
        this.m_advancedPanel = this.createAdvancedPanel();
        c.fill = 1;
        c.gridy = -1;
        c.weighty = 1.0;
        this.add((Component)this.m_basicPanel, c);
        this.add((Component)this.m_advancedPanel, c);
        this.m_advancedPanel.setVisible(false);
        this.m_basicPanel.setVisible(false);
    }

    private JPanel createBasicPanel() {
        JLabel correlationExpressionLabel = new JLabel(VWResource.s_correlationExpressionColon);
        this.m_correlationExpression = new JTextField();
        this.m_correlationExpression.setEditable(false);
        this.m_correlationExpression.setBorder(null);
        JPanel correlationExpressionPanel = new JPanel(new BorderLayout(10, 0));
        correlationExpressionPanel.add((Component)correlationExpressionLabel, "Before");
        correlationExpressionPanel.add((Component)this.m_correlationExpression, "Center");
        JLabel correlationParamLabel = new JLabel(VWResource.s_operationParameterContainsCorrelationColon);
        this.m_correlationParam = new JTextField();
        this.m_correlationParam.setEditable(false);
        this.m_correlationParam.setBorder(null);
        JPanel correlationParamPanel = new JPanel(new BorderLayout(10, 0));
        correlationParamPanel.add((Component)correlationParamLabel, "Before");
        correlationParamPanel.add((Component)this.m_correlationParam, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.fill = 2;
        panel.add((Component)correlationParamPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        panel.add((Component)correlationExpressionPanel, c);
        return panel;
    }

    private JPanel createAdvancedPanel() {
        JLabel nameLabel = new JLabel(VWResource.s_nameColon);
        this.m_receiveName = new JTextField();
        this.m_receiveName.setEditable(false);
        this.m_receiveName.setBorder(null);
        JPanel namePanel = new JPanel(new BorderLayout(10, 0));
        namePanel.add((Component)nameLabel, "Before");
        namePanel.add((Component)this.m_receiveName, "Center");
        VWToolbarBorder paramsBorder = new VWToolbarBorder(VWResource.s_properties, 0);
        JPanel paramsPanel = paramsBorder.getClientPanel();
        paramsPanel.setLayout(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_receiveParamsTable = new VWTable();
        this.m_receiveParamsTable.setRowSelectionAllowed(true);
        this.m_receiveParamsTable.setColumnSelectionAllowed(false);
        this.m_receiveParamsTable.setSelectionMode(0);
        paramsPanel.add((Component)new JScrollPane(this.m_receiveParamsTable), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.fill = 2;
        panel.add((Component)namePanel, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)paramsBorder, c);
        return panel;
    }

    private void reinitialize() {
        try {
            this.m_receiveParamsTableModel = null;
            this.m_basicPanel.setVisible(false);
            this.m_advancedPanel.setVisible(false);
            int mode = this.m_parent.getReceiveMessageType();
            if (mode == 0) {
                this.m_basicPanel.setVisible(true);
            } else if (mode == 1) {
                this.m_advancedPanel.setVisible(true);
            }
            String correlationExpression = ((VWReceiveInstruction)this.m_instructionDef).getCorrelationValueExpression();
            this.m_parent.setTextField(this.m_correlationExpression, correlationExpression);
            String correlationParam = VWResource.s_none;
            int paramSeqNum = ((VWReceiveInstruction)this.m_instructionDef).getCorrelationParameterSequenceNumber();
            VWWebServiceParameterDefinition[] params = ((VWReceiveInstruction)this.m_instructionDef).getParameterDefinitions();
            if (params != null && paramSeqNum != -1) {
                correlationParam = params[paramSeqNum].toString();
            }
            this.m_parent.setTextField(this.m_correlationParam, correlationParam);
            String name = ((VWReceiveInstruction)this.m_instructionDef).getCorrelationSetName();
            this.m_parent.setTextField(this.m_receiveName, name);
            this.m_receiveParams = ((VWReceiveInstruction)this.m_instructionDef).getCorrelationSetProperties();
            if (this.m_receiveParams != null) {
                if (this.m_receiveParamsTableModel == null) {
                    this.m_receiveParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWReceiveCorrelationSetPanel.this.m_receiveParamsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWReceiveCorrelationSetPanel.this.m_receiveParamsTableColumnNames[1];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWReceiveCorrelationSetPanel.this.m_receiveParamsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWReceiveCorrelationSetPanel.this.m_receiveParams != null) {
                                return VWReceiveCorrelationSetPanel.this.m_receiveParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWReceiveCorrelationSetPanel.this.m_receiveParams != null && nRowIndex >= 0 && nRowIndex < VWReceiveCorrelationSetPanel.this.m_receiveParams.length) {
                                    String[] paramDef = VWReceiveCorrelationSetPanel.this.m_receiveParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef[0];
                                        }
                                        case 1: {
                                            return paramDef[1];
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_receiveParamsTable.setModel(this.m_receiveParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_receiveParamsTable, this.m_receiveParamsTableModel);
                this.m_receiveParamsTableModel.fireTableDataChanged();
                this.m_receiveParamsTable.fitColumnsInTable();
                this.m_receiveParamsTable.updateUI();
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        int i;
        this.m_correlationExpression = null;
        this.m_correlationParam = null;
        this.m_receiveName = null;
        this.m_basicPanel = null;
        this.m_advancedPanel = null;
        for (i = 0; i < this.m_receiveParamsTableColumnNames.length; ++i) {
            this.m_receiveParamsTableColumnNames[i] = null;
        }
        if (this.m_receiveParams != null) {
            for (i = 0; i < this.m_receiveParams.length; ++i) {
                this.m_receiveParams[i] = null;
            }
        }
        if (this.m_receiveParamsTable != null) {
            this.m_receiveParamsTable.removeReferences();
            this.m_receiveParamsTable = null;
        }
        this.m_receiveParamsTableModel = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

